% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_svi.R
\name{find_svi}
\alias{find_svi}
\title{Retrieve census data and calculate SVI for one or multiple year(s)/state(s)}
\usage{
find_svi(year, state = NULL, geography, key = NULL, full.table = FALSE)
}
\arguments{
\item{year}{A vector containing years of interest (available 2012-2021).
Length >=1. Acting as pairs with \code{state}, \code{year} should be of the same
length as \code{state}. The exception is when it's a single year entry (length
1), other than providing one state of interest, supply \code{state = NULL} as
default or \code{state = 'US'} retrieves and processes nation level data to
obtain SVI.}

\item{state}{A vector containing states of interest. Length >=0. Length 0
(\code{state = NULL}), or \code{state = 'US'} must be used with single year argument,
when SVI is calculated from nation-level census data. In other cases,
\code{state} must have the same elements as \code{year} (same length).}

\item{geography}{One geography level of interest for all year-state
combination (e.g."county", "zcta", "tract").}

\item{key}{Your Census API key. Obtain one at
\url{https://api.census.gov/data/key_signup.html}. To set up, use
\code{tidycensus::census_api_key("YOUR KEY GOES HERE")}, or include it as an argument.}

\item{full.table}{Default as \code{FALSE}, returning SVI table with only "GEOID",
and SVI for each theme and all themes. If set as \code{TRUE}, a full SVI table
with individual SVI variables and intermediate ranking calculations are
also included in addition to the theme-related SVIs (similar style to
tables from \href{https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html}{CDC/ATSDR database}).}
}
\value{
A tibble of summarised SVI for one or multiple year-state combination(s)
of interest. Rows represent the geographic units, and columns represent its
SVI for each theme and all themes. Additional two columns at the end
indicate the corresponding state and year information. For \code{full.table = TRUE}, estimated count and percentage values for individual SVI variables
are also included. For description of variable names (column names), please
refer to \href{https://www.atsdr.cdc.gov/placeandhealth/svi/data_documentation_download.html}{CDC/ATSDR documentation}.
}
\description{
\code{find_svi()} is like a wrapper for \code{\link[=get_census_data]{get_census_data()}} and
\code{\link[=get_svi]{get_svi()}} that retrieves census data and produces SVI for one or
multiple years(s) and state(s). For multiple year-state entries, SVI is
obtained from percentile rankings for each entry and summarised into one
table. Note that a Census API key is required for this function to work,
which can be obtained at \url{https://api.census.gov/data/key_signup.html} and
set up using \code{\link[tidycensus:census_api_key]{tidycensus::census_api_key()}}.
}
\examples{
\dontshow{if (Sys.getenv("CENSUS_API_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Census API key required
# For one year-state entry
find_svi(
      year = 2019,
      state = "AZ",
      geography = "county"
   )


# For multiple year-state pairs
## All ZCTAs for 2017-AZ; 2017-DE; and 2018-DC
year <- c(2017, 2017, 2018)
state <- c("AZ", "DE", "DC")
info <- data.frame(year, state)

find_svi(
      year = info$year,
      state = info$state,
      geography = "zcta"
   )

\dontshow{\}) # examplesIf}
}
