% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racing_helpers.R
\name{collect_predictions}
\alias{collect_predictions}
\alias{collect_predictions.tune_race}
\alias{collect_metrics.tune_race}
\title{Obtain and format results produced by racing functions}
\usage{
\method{collect_predictions}{tune_race}(
  x,
  ...,
  summarize = FALSE,
  parameters = NULL,
  all_configs = FALSE
)

\method{collect_metrics}{tune_race}(
  x,
  ...,
  summarize = TRUE,
  type = c("long", "wide"),
  all_configs = FALSE
)
}
\arguments{
\item{x}{The results of \code{\link[tune:tune_grid]{tune_grid()}}, \code{\link[tune:tune_bayes]{tune_bayes()}}, \code{\link[tune:fit_resamples]{fit_resamples()}},
or \code{\link[tune:last_fit]{last_fit()}}. For \code{\link[tune:collect_predictions]{collect_predictions()}}, the control option \code{save_pred = TRUE} should have been used.}

\item{...}{Not currently used.}

\item{summarize}{A logical; should metrics be summarized over resamples
(\code{TRUE}) or return the values for each individual resample. Note that, if \code{x}
is created by \code{\link[tune:last_fit]{last_fit()}}, \code{summarize} has no effect. For the other object
types, the method of summarizing predictions is detailed below.}

\item{parameters}{An optional tibble of tuning parameter values that can be
used to filter the predicted values before processing. This tibble should
only have columns for each tuning parameter identifier (e.g. \code{"my_param"}
if \code{tune("my_param")} was used).}

\item{all_configs}{A logical: should we return the complete set of model
configurations or just those that made it to the end of the race (the
default).}

\item{type}{One of \code{"long"} (the default) or \code{"wide"}. When \code{type = "long"},
output has columns \code{.metric} and one of \code{.estimate} or \code{mean}.
\code{.estimate}/\code{mean} gives the values for the \code{.metric}. When \code{type = "wide"},
each metric has its own column and the \code{n} and \code{std_err} columns are removed,
if they exist.}
}
\value{
A tibble. The column names depend on the results and the mode of the
model.
}
\description{
Obtain and format results produced by racing functions
}
\details{
For \code{\link[=collect_metrics]{collect_metrics()}} and \code{\link[=collect_predictions]{collect_predictions()}}, when unsummarized,
there are columns for each tuning parameter (using the \code{id} from \code{\link[=tune]{tune()}},
if any).
\code{\link[=collect_metrics]{collect_metrics()}} also has columns \code{.metric}, and \code{.estimator}.  When the
results are summarized, there are columns for \code{mean}, \code{n}, and \code{std_err}.
When not summarized, the additional columns for the resampling identifier(s)
and \code{.estimate}.

For \code{\link[=collect_predictions]{collect_predictions()}}, there are additional columns for the resampling
identifier(s), columns for the predicted values (e.g., \code{.pred},
\code{.pred_class}, etc.), and a column for the outcome(s) using the original
column name(s) in the data.

\code{\link[=collect_predictions]{collect_predictions()}} can summarize the various results over
replicate out-of-sample predictions. For example, when using the bootstrap,
each row in the original training set has multiple holdout predictions
(across assessment sets). To convert these results to a format where every
training set same has a single predicted value, the results are averaged
over replicate predictions.

For regression cases, the numeric predictions are simply averaged. For
classification models, the problem is more complex. When class probabilities
are used, these are averaged and then re-normalized to make sure that they
add to one. If hard class predictions also exist in the data, then these are
determined from the summarized probability estimates (so that they match).
If only hard class predictions are in the results, then the mode is used to
summarize.

For racing results, it is best to only
collect model configurations that finished the race (i.e., were completely
resampled). Comparing performance metrics for configurations averaged with
different resamples is likely to lead to inappropriate results.
}
