% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{compare_areas}
\alias{compare_areas}
\title{Plot compare areas chart}
\usage{
compare_areas(
  data,
  area,
  value,
  lowerci,
  upperci,
  fill,
  order = "desc",
  top_areas,
  title = "",
  xlab = "",
  ylab = "",
  legend.position = "bottom",
  display.values = FALSE,
  dps = 1
)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{area}{field containing variable to be plotted on y axis (unquoted)}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{lowerci}{field containing variable to be plotted as lower confidence
interval (unquoted - not required)}

\item{upperci}{string; field containing variable to be plotted as upper confidence
interval (unquoted - not required)}

\item{fill}{field to be used to determine the colouring of the bars (unquoted)}

\item{order}{one of "alphabetical", "asc" or "desc" - to determine how to
order the bars}

\item{top_areas}{character vector; the areas to fix at the top of the chart}

\item{title}{string; title of chart}

\item{xlab}{string; x-axis title}

\item{ylab}{string; y-axis title}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{display.values}{logical; where or not to display the rounded values
next to the bars on the chart}

\item{dps}{number; number of decimal places to be displayed when
display.values = TRUE. The default is 1.}
}
\value{
a ggplot of a compare areas chart
}
\description{
Returns ggplot of compare areas chart
}
\examples{
library(dplyr)
df <- create_test_data()
parent <- "PAC11"
top_names <- c("C001", parent)
ordered_levels <- c("Better",
                    "Similar",
                    "Worse",
                    "Not compared")
df_ca <- df \%>\%
        filter(IndicatorName == "Indicator 3",
               (AreaCode \%in\% top_names |
                        ParentAreaCode == parent))
p <- compare_areas(df_ca, AreaCode, Value,
                   fill = Significance,
                   lowerci = LCI,
                   upperci = UCI,
                   order = "desc",
                   top_areas = top_names,
                   title = "Compare the local areas")
p

}
\seealso{
Other quick charts: 
\code{\link{box_plots}()},
\code{\link{compare_indicators}()},
\code{\link{map}()},
\code{\link{overview}()},
\code{\link{population}()},
\code{\link{trends}()}
}
\concept{quick charts}
