% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{FCRN_foreign_trade}
\alias{FCRN_foreign_trade}
\title{Frequency Containment Reserve for Normal operation, foreign trade}
\usage{
FCRN_foreign_trade(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the volume of the foreign trade
of frequency containment reserve for normal operation (FCR-N) capacity.
Positive numbers indicate import of capacity to Finland and negative
numbers indicate export of capacity from Finland. The data contains the
traded capacity for Sweden, Norway, Estonia and Russia. The data will be
published 22:45 (EET) on previous evening.
}
\description{
Check https://data.fingrid.fi/en/dataset/taajuusohjattu-kayttoreservi-ulkomaankauppa
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- FCRN_foreign_trade(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
