% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{biliteral_trade_capacity_FI_to_RUS}
\alias{biliteral_trade_capacity_FI_to_RUS}
\title{Bilateral trade capacity FI-RUS}
\usage{
biliteral_trade_capacity_FI_to_RUS(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the bilateral capacity on the
400 kV connection from Russia to Finland that is reserved to bilateral
trade of the following commercial day. The capacity is confirmed by
Fingrid and the Russian parties.
}
\description{
Check https://data.fingrid.fi/en/dataset/bilateral-trade-capacity-fi-rus
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- biliteral_trade_capacity_FI_to_RUS(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
