% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_prepare_conll-u.R
\name{fst_rm_stop_punct}
\alias{fst_rm_stop_punct}
\title{Remove Finnish stopwords and punctuation from CoNLL-U dataframe}
\usage{
fst_rm_stop_punct(data, stopword_list = "nltk")
}
\arguments{
\item{data}{A dataframe of Finnish text in CoNLL-U format.}

\item{stopword_list}{A valid Finnish stopword list, default is `"nltk"`.}
}
\value{
A dataframe of Finnish text in CoNLL-U format without stopwords and
 punctuation.
}
\description{
Removes stopwords and punctuation from a dataframe containing Finnish survey
text data which is already in CoNLL-U format.
}
\examples{
fst_rm_stop_punct(conllu_dev_q11_3)
fst_rm_stop_punct(conllu_dev_q11_1, stopword_list <- "snowball")
fst_rm_stop_punct(conllu_cb_bullying, "stopwords-iso")
}
