% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_length_compare}
\alias{fst_length_compare}
\title{Compare response lengths}
\usage{
fst_length_compare(
  data,
  field,
  incl_sentences = TRUE,
  exclude_nulls = FALSE,
  rename_nulls = "null_data"
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format with additional `field`
column for splitting data.}

\item{field}{Column in `data` used for splitting groups}

\item{incl_sentences}{Whether to include sentence data in table, default is
`TRUE`.}

\item{exclude_nulls}{Whether to include NULLs in `field` column, default is
`FALSE`}

\item{rename_nulls}{What to fill NULL values with if `exclude_nulls = FALSE`.}
}
\value{
Dataframe summarising response lengths.
}
\description{
Compare length of text responses for different groups of participants. Data
is split based on different values in the `field` column of formatted data.
Results will be shown within the plots pane.
}
\examples{
fst_length_compare(fst_child, 'gender')
fst_length_compare(fst_dev_coop, 'education_level', incl_sentences = FALSE)
}
