% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_ngrams_table2}
\alias{fst_ngrams_table2}
\title{Make Top N-grams Table 2}
\usage{
fst_ngrams_table2(
  data,
  number = 10,
  ngrams = 1,
  norm = NULL,
  pos_filter = NULL,
  strict = TRUE,
  use_svydesign_weights = FALSE,
  id = "",
  svydesign = NULL,
  use_column_weights = FALSE
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format, with optional additional
columns.}

\item{number}{The number of n-grams to return, default is `10`.}

\item{ngrams}{The type of n-grams to return, default is `1`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}

\item{use_svydesign_weights}{Option to weight words in the table using
weights from a `svydesign` containing the raw data, default is `FALSE`}

\item{id}{ID column from raw data, required if `use_svydesign_weights = TRUE`
and must match the `docid` in formatted `data`.}

\item{svydesign}{A `svydesign` which contains the raw data and weights,
required if `use_svydesign_weights = TRUE`.}

\item{use_column_weights}{Option to weight words in the table using
weights from  formatted data which includes addition `weight` column,
default is `FALSE`}
}
\value{
A table of the most frequently occurring n-grams in the data.
}
\description{
Creates a table of the most frequently-occurring n-grams within the
data. Optionally, weights can be provided either through a `weight` column
in the formatted data, or from a `svydesign` object with the raw
(preformatted) data.
Equivalent to `fst_get_top_ngrams` but doesn't print message about ties.
}
\examples{
fst_ngrams_table2(fst_child, norm = NULL)
fst_ngrams_table2(fst_child, ngrams = 2, norm = "number_resp")
c <- fst_child_2
s <- survey::svydesign(id=~1, weights= ~paino, data = child)
i <- 'fsd_id'
T <- TRUE
fst_ngrams_table2(c, 10, 2, use_svydesign_weights = T, svydesign = s, id = i)
}
