% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_account.R
\name{delete_account}
\alias{delete_account}
\title{Delete account}
\usage{
delete_account(id_token)
}
\arguments{
\item{id_token}{The Firebase ID token of the user to delete.}
}
\value{
A named list with the following items:
\itemize{
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Delete account
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-delete-account}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  # first sign in user and get the 'id_token':
  user <- sign_in(email = "user@gmail.com", password = "password")
  id_token <- user$idToken

  # delete user account:
  response <- delete_account(id_token = id_token)
  response
}
}
