% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfw.summarize.R
\name{gfw.summarize}
\alias{gfw.summarize}
\title{Summarize GFW data on fishing effort}
\usage{
gfw.summarize(df)
}
\arguments{
\item{df}{A dataframe object as returned by passing the result of `bait.gfw.effort()` to `fish()`.}
}
\value{
A dataframe.
}
\description{
Wrapper function for `dplyr::summarise()` that summarizes GFW data into the most important measures of central tendency for fishing_hours and hours, creating a new dataframe. It will have one (or more) rows for each combination of grouping variables; if there are no grouping variables, the output will have a single row summarising all observations in the input.
}
\examples{
\donttest{
bait <- bait.gfw.effort(table = "fishing_effort_byvessel_v2", end_date="2012-01-02")

catch <- fish(bait = bait)

summary <- gfw.summarize(catch)
}

}
\seealso{
[bait.gfw.effort()] [fish()] [dplyr::summarise()] [dplyr::group_by()]
}
