#' Morphological data of adult fish
#'
#' A dataset containing morphological data for adult of a migratory
#' fish species. It matches with the "adult_growths" dataset
#'
#' @format A dataset containing 48 rows and 5 variables
#' \describe{
#' \item{standard_length}{standard length of the fish (distance from
#' posterior to caudal peduncle)}
#' \item{body_depth}{body depth of the fish at its maximum point}
#' \item{fish_id}{a unique identifier for each fish}
#' \item{site}{one of two collection sites}
#' \item{month}{month that the fish was collected on}
#' }
#' @usage data(adult_morphologies)
#' @example {
#' data(adult_morphologies)
#' }

"adult_morphologies"
