% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\name{fitBin}
\alias{fitBin}
\title{Fitting the Binomial Distributon when binomial random variable, frequency and probability
value are given}
\usage{
fitBin(x,obs.freq,p=0,print=T)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{obs.freq}{vector of frequencies}

\item{p}{single value for probability}

\item{print}{logical value for print or not}
}
\value{
The output of \code{fitBin} gives a list format consisting

\code{bin.ran.var} binomial random variables

\code{obs.freq} corresponding observed frequencies

\code{exp.freq} corresponding expected frequencies

\code{statistic} chi-squared test statistics value

\code{df} degree of freedom

\code{p.value} prboability value by chi-squared test statistic
}
\description{
The function will fit the binomial distribution when random variables, corresponding
frequencies and probability value are given. It will provide the expected frequencies, chi-squared
test statistics value, p value and degree of freedom  so that it can be
seen if this distribution fits the data.
}
\details{
\deqn{x = 0,1,2,...}
\deqn{0 \le p \le 1}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D=0:7      #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#fitting when the random variable,frequencies,probability value are given.
fitBin(No.D.D,Obs.fre.1,p=0.7)

fitBin(No.D.D,Obs.fre.1,p=0.7,FALSE)$exp.freq  #extracting the expected frequencies

#fitting when the random variable,frequencies are given.
fitBin(No.D.D,Obs.fre.1)

}
