% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{mazBETA}
\alias{mazBETA}
\title{Beta Distribution}
\usage{
mazBETA(r,a,b)
}
\arguments{
\item{r}{vector of moments}

\item{a}{single value for shape parameter alpha representing as a}

\item{b}{single value for shape parameter beta representing as b}
}
\value{
The output of \code{mazBETA} gives the moments about zero in vector form.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moment about zero values for the
Beta Distribution bounded between [0,1]
}
\details{
The probability density function and cumulative density function of a unit
bounded beta distribution with random variable P are given by

\deqn{g_{P}(p)= \frac{p^{a-1}(1-p)^{b-1}}{B(a,b)} } ;            \eqn{0 \le p \le 1}
\deqn{G_{P}(p)= \frac{B_p(a,b)}{B(a,b)} } ;                   \eqn{0 \le p \le 1}
\deqn{a,b > 0}

The mean and the variance are denoted by
\deqn{E[P]= \frac{a}{a+b} }
\deqn{var[P]= \frac{ab}{(a+b)^2(a+b+1)} }

The moments about zero is denoted as
\deqn{E[P^r]= \prod_{i=0}^{r-1} (\frac{a+i}{a+b+i}) }
\eqn{r = 1,2,3,...}

Defined as \eqn{B_p(a,b)=\int^p_0 t^{a-1} (1-t)^{b-1}\,dt} is
incomplete beta integrals  and \eqn{B(a,b)} is the beta function.

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
messages will be provided to go further
}
\examples{
#plotting the random variables and probability values
col<-rainbow(4)
a<-c(1,2,5,10)
plot(0,0,main="Probability density graph",xlab="Random variable",ylab="Probabiility density values",
xlim = c(0,1),ylim = c(0,4))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),dBETA(seq(0,1,by=0.01),a[i],a[i])$pdf,col = col[i])
}

dBETA(seq(0,1,by=0.01),2,3)$pdf   #extracting the pdf values
dBETA(seq(0,1,by=0.01),2,3)$mean  #extracting the mean
dBETA(seq(0,1,by=0.01),2,3)$var   #extracting the variance

#plotting the random variables and cumulative probability values
col<-rainbow(4)
a<-c(1,2,5,10)
plot(0,0,main="Cumulative density graph",xlab="Random variable",ylab="Cumulative density values",
xlim = c(0,1),ylim = c(0,1))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),pBETA(seq(0,1,by=0.01),a[i],a[i]),col = col[i])
}

pBETA(seq(0,1,by=0.01),2,3)   #acquiring the cumulative probability values
mazBETA(1.4,3,2)              #acquiring the moment about zero values
mazBETA(2,3,2)-mazBETA(1,3,2)^2 #acquiring the variance for a=3,b=2
#only the integer value of moments is taken here because moments cannot be decimal
mazBETA(1.9,5.5,6)

}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1994) Continuous Univariate Distributions, Vol. 2,
Wiley Series in Probability and Mathematical Statistics, Wiley

Trenkler, G., 1996. Continuous univariate distributions. Computational Statistics & Data Analysis,
21(1), p.119.

Available at: \url{http://linkinghub.elsevier.com/retrieve/pii/0167947396900158} .
}
\seealso{
\code{\link[stats]{Beta}}

or

\url{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/Beta.html}
}
