% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{fitBetaBin}
\alias{fitBetaBin}
\title{Fitting the Beta-Binomial Distribution when binomial random variable, frequency and shape
parameters a and b are given}
\usage{
fitBetaBin(x,obs.freq,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}
}
\value{
The output of \code{fitBetaBin} gives the class format \code{fitBB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitBB} fitted values of \code{dBetaBin}.

\code{NegLL} Negative Log Likelihood value.

\code{a} estimated value for alpha parameter as a.

\code{b} estimated value for alpha parameter as b.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted} can be
used to extract specific outputs.
}
\description{
The function will fit the Beta-Binomial distribution when random variables, corresponding
frequencies and shape parameters are given. It will provide the expected frequencies, chi-squared
test statistics value, p value, degree of freedom and over dispersion value so that it can be
seen if this distribution fits the data.
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...,n}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D=0:7    #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLEBetaBin,start = list(a=0.1,b=0.1),
data = list(x=No.D.D,freq=Obs.fre.1)))

bbmle::coef(parameters)   #extracting the parameters a and b
aBetaBin=bbmle::coef(parameters)[1]  #assigning the parameter a
bBetaBin=bbmle::coef(parameters)[2]  #assigning the parameter b

#fitting when the random variable,frequencies,shape parameter values are given.
fitBetaBin(No.D.D,Obs.fre.1,aBetaBin,bBetaBin)

#estimating the parameters using moment generating function methods
results<-EstMGFBetaBin(No.D.D,Obs.fre.1)
results

aBetaBin1=results$a  #assigning the estimated a
bBetaBin1=results$b  #assigning the estimated b

#fitting when the random variable,frequencies,shape parameter values are given.
BB<-fitBetaBin(No.D.D,Obs.fre.1,aBetaBin1,bBetaBin1)

#extracting the expected frequencies
fitted(BB)

#extracting the residuals
residuals(BB)

}
\references{
Young-Xu, Y. & Chan, K.A., 2008. Pooling overdispersed binomial data to estimate event rate. BMC medical
research methodology, 8(1), p.58.

Available at: \url{http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=2538541&tool=pmcentrez&rendertype=abstract}.

Trenkler, G., 1996. Continuous univariate distributions. Computational Statistics & Data Analysis, 21(1), p.119.

Available at: \url{http://linkinghub.elsevier.com/retrieve/pii/0167947396900158}.

Hughes, G., 1993. Using the Beta-Binomial Distribution to Describe Aggregated Patterns of Disease
Incidence. Phytopathology, 83(9), p.759.

Available at: \url{http://www.apsnet.org/publications/phytopathology/backissues/Documents/1993Abstracts/Phyto_83_759.htm}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
