% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{heart_rate_heatmap}
\alias{heart_rate_heatmap}
\title{Heart Rate Intraday Heatmap (by extracting the 'min.', 'median' and 'max.' values of the day)}
\usage{
heart_rate_heatmap(heart_rate_intraday_data, angle_x_axis = 0)
}
\arguments{
\item{heart_rate_intraday_data}{a list object specifying the intraday heart rate data (this is one of the sublists returned from the 'heart_rate_time_series' function)}

\item{angle_x_axis}{an integer specifying the angle of the x-axis labels. The default values is 0 (it can take for instance values such as 45, 90 etc.)}
}
\value{
a plot object of class ggplot2
}
\description{
Heart Rate Intraday Heatmap (by extracting the 'min.', 'median' and 'max.' values of the day)
}
\examples{

\dontrun{

require(fitbitViz)

#...........................................
# first compute the heart rate intraday data
#...........................................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

heart_dat = heart_rate_time_series(user_id = USER_ID,
                                   token = token,
                                   date_start = '2021-03-09',
                                   date_end = '2021-03-16',
                                   time_start = '00:00',
                                   time_end = '23:59',
                                   detail_level = '1min',
                                   ggplot_intraday = TRUE,
                                   verbose = TRUE,
                                   show_nchar_case_error = 135)

#..........................................
# use the heart-rate-intraday data as input
# to the 'heart_rate_heatmap' function
#..........................................

hrt_heat = heart_rate_heatmap(heart_rate_intraday_data =  heart_dat$heart_rate_intraday,
                              angle_x_axis = 0)
hrt_heat

}
}
