% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{coeftable.default}
\alias{coeftable.default}
\alias{se.default}
\alias{tstat.default}
\alias{pvalue.default}
\alias{se.matrix}
\title{Extracts the coefficients table from an estimation}
\usage{
\method{coeftable}{default}(object, keep, drop, order, ...)

\method{se}{default}(object, keep, drop, order, ...)

\method{tstat}{default}(object, keep, drop, order, ...)

\method{pvalue}{default}(object, keep, drop, order, ...)

\method{se}{matrix}(object, keep, drop, order, ...)
}
\arguments{
\item{object}{The result of an estimation (a fitted model object). Note that this function is made to work with \code{fixest} objects so it may not work for the specific model you provide.}

\item{keep}{Character vector. This element is used to display only a subset of variables. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). Each variable satisfying any of the regular expressions will be kept. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is kept). See details.}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). Each variable satisfying any of the regular expressions will be discarded. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \verb{drop = "x[[:digit:]]\{2\}}". If the first character is an exclamation mark, the effect is reversed (e.g. drop = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is dropped). See details.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a vector of regular expressions (see \code{\link[base:regex]{base::regex}} help for more info). The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions. This argument is applied post aliasing (see argument \code{dict}). Example: you have the following variables: \code{month1} to \code{month6}, then \code{x1} to \code{x5}, then \code{year1} to \code{year6}. If you want to display first the x's, then the years, then the months you could use: \code{order = c("x", "year")}. If the first character is an exclamation mark, the effect is reversed (e.g. order = "!Intercept" means: every variable that does not contain \dQuote{Intercept} goes first).  See details.}

\item{...}{Other arguments that will be passed to \code{summary}.

First the method summary is applied if needed, then the coefficients table is extracted from its output.

The default method is very naive and hopes that the resulting coefficients table contained in the summary of the fitted model is well formed: this assumption is very often wrong. Anyway, there is no development intended since the coeftable/se/pvalue/tstat series of methods is only intended to work well with \code{fixest} objects. To extract the coefficients table from fitted models in a general way, it's better to use \href{https://broom.tidymodels.org/}{tidy from broom}.}
}
\value{
Returns a matrix (\code{coeftable}) or vectors.
}
\description{
Default method to extracts the coefficients table and its sub-components from an estimation.
}
\section{Functions}{
\itemize{
\item \code{se.default}: Extracts the standard-errors from an estimation

\item \code{tstat.default}: Extracts the standard-errors from an estimation

\item \code{pvalue.default}: Extracts the p-values from an estimation

\item \code{se.matrix}: Extracts the standard-errors from a VCOV matrix
}}

\examples{

# NOTA: This function is really made to handle fixest objects
# The default methods works for simple structures, but you'd be
# likely better off with broom::tidy for other models

est = lm(mpg ~ cyl, mtcars)
coeftable(est)

se(est)





}
