% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{etable}
\alias{etable}
\alias{esttex}
\alias{esttable}
\title{Estimations table (export the results of multiples estimations to a DF or to Latex)}
\usage{
etable(..., se = c("standard", "white", "cluster", "twoway", "threeway",
  "fourway"), dof = getFixest_dof(), cluster, digits = 4, tex, fitstat,
  title, coefstat = c("se", "tstat", "confint"), ci = 0.95,
  sdBelow = TRUE, keep, drop, order, dict = getFixest_dict(), file,
  replace = FALSE, convergence, signifCode, label, float, subtitles,
  fixef_sizes = FALSE, fixef_sizes.simplify = TRUE,
  yesNoFixef = c("Yes", "No"), keepFactors = TRUE, family,
  powerBelow = -5, interaction.combine = " $\\\\times $ ", depvar)

esttex(..., se = c("standard", "white", "cluster", "twoway", "threeway",
  "fourway"), dof = getFixest_dof(), cluster, digits = 4, fitstat,
  coefstat = c("se", "tstat", "confint"), ci = 0.95, title,
  float = float, sdBelow = TRUE, keep, drop, order,
  dict = getFixest_dict(), file, replace = FALSE, convergence,
  signifCode = c(`***` = 0.01, `**` = 0.05, `*` = 0.1), label, subtitles,
  fixef_sizes = FALSE, fixef_sizes.simplify = TRUE,
  yesNoFixef = c("Yes", "No"), keepFactors = TRUE, family,
  powerBelow = -5, interaction.combine = " $\\\\times $ ")

esttable(..., se = c("standard", "white", "cluster", "twoway",
  "threeway", "fourway"), dof = getFixest_dof(), cluster,
  coefstat = c("se", "tstat", "confint"), ci = 0.95, depvar, keep,
  drop, order, digits = 4, fitstat, convergence, signifCode = c(`***` =
  0.001, `**` = 0.01, `*` = 0.05, . = 0.1), subtitles,
  keepFactors = FALSE, family)
}
\arguments{
\item{...}{Used to capture different \code{fixest} estimation objects (obtained with \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}). Note that any other type of element is discarded. Note that you can give a list of \code{fixest} objects.}

\item{se}{Character scalar. Which kind of standard error should be computed: \dQuote{standard}, \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}? By default if there are clusters in the estimation: \code{se = "cluster"}, otherwise \code{se = "standard"}. Note that this argument can be implicitly deduced from the argument \code{cluster}.}

\item{dof}{An object of class \code{dof.type} obtained with the function \code{\link[fixest]{dof}}. Represent how the degree of freedom correction should be done. Defaults to \code{dof(fixef="nested", exact=FALSE, cluster = TRUE)}. See the help of the function \code{\link[fixest]{dof}} for details.}

\item{cluster}{Tells how to cluster the standard-errors (if clustering is requested). Can be either a list of vectors, a character vector of variable names, a formula or an integer vector. Assume we want to perform 2-way clustering over \code{var1} and \code{var2} contained in the data.frame \code{base} used for the estimation. All the following \code{cluster} arguments are valid and do the same thing: \code{cluster = base[, c("var1, "var2")]}, \code{cluster = c("var1, "var2")}, \code{cluster = ~var1+var2}. If the two variables were used as clusters in the estimation, you could further use \code{cluster = 1:2} or leave it blank with \code{se = "twoway"} (assuming \code{var1} [resp. \code{var2}] was the 1st [res. 2nd] cluster).}

\item{digits}{Integer, default is 4. The number of digits to be displayed.}

\item{tex}{Logical: whether the results should be a data.frame or a Latex table. By default, this argument is \code{TRUE} if the argument \code{file} (used for exportation) is not missing; it is equal to \code{FALSE} otherwise.}

\item{fitstat}{A character vector or a one sided formula. A vector listing which fit statistics to display. The valid types are 'll', 'aic', 'bic' and r2 types like 'r2', 'pr2', 'war2', etc (see all valid types in \code{\link[fixest]{r2}}). The default value depends on the models to display. Example of use: \code{fitstat=c('sq.cor', 'ar2', 'war2')}, or \code{fitstat=~sq.cor+ar2+war2} using a formula.}

\item{title}{(Tex only.) Character scalar. The title of the Latex table.}

\item{coefstat}{One of \code{"se"} (default), \code{"tstat"} or \code{"confint"}. The statistic to report for each coefficient: the standard-error, the t-statistics or the confidence interval. You can adjust the confidence interval with the argument \code{ci}.}

\item{ci}{Level of the confidence interval, defaults to \code{0.95}. Only used if \code{coefstat = confint}.}

\item{sdBelow}{(Tex only.) Logical, default is \code{TRUE}. Should the standard-errors be displayed below the coefficients?}

\item{keep}{Character vector. This element is used to display only a subset of variables. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be kept. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{keep = "x[[:digit:]]$"}. If the first character is an exclamation mark, the effect is reversed (e.g. keep = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is kept). See details.}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). Each variable satisfying any of the regular expressions will be discarded. This argument is applied post aliasing (see argument \code{dict}). Example: you have the variable \code{x1} to \code{x55} and want to display only \code{x1} to \code{x9}, then you could use \code{drop = "x[[:digit:]]{2}"}. If the first character is an exclamation mark, the effect is reversed (e.g. drop = "!Intercept" means: every variable that does not contain \dQuote{Intercept} is dropped). See details.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a vector of regular expressions (see \code{\link[base]{regex}} help for more info). The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions. This argument is applied post aliasing (see argument \code{dict}). Example: you have the following variables: \code{month1} to \code{month6}, then \code{x1} to \code{x5}, then \code{year1} to \code{year6}. If you want to display first the x's, then the years, then the months you could use: \code{order = c("x", "year")}. If the first character is an exclamation mark, the effect is reversed (e.g. order = "!Intercept" means: every variable that does not contain \dQuote{Intercept} goes first).  See details.}

\item{dict}{(Tex only.) A named character vector. It changes the original variable names to the ones contained in the \code{dict}. E.g. to change the variables named \code{a} and \code{b3} to (resp.) \dQuote{$log(a)$} and to \dQuote{$bonus^3$}, use \code{dict=c(a="$log(a)$",b3="$bonus^3$")}. By default it is equal to \code{getFixest_dict()}, a default dictionary which can be set with \code{\link[fixest]{setFixest_dict}}.}

\item{file}{A character scalar. If provided, the Latex (or data frame) table will be saved in a file whose path is \code{file}. If you provide this argument, then a Latex table will be exported, to export a regular \code{data.frame}, use argument \code{tex = FALSE}.}

\item{replace}{Logical, default is \code{FALSE}. Only used if option \code{file} is used. Should the exported table be written in a new file that replaces any existing file?}

\item{convergence}{Logical, default is missing. Should the convergence state of the algorithm be displayed? By default, convergence information is displayed if at least one model did not converge.}

\item{signifCode}{Named numeric vector, used to provide the significance codes with respect to the p-value of the coefficients. Default is \code{c("***"=0.01, "**"=0.05, "*"=0.10)} for a Latex table and \code{c("***"=0.001, "**"=0.01, "*"=0.05, "."=0.10)} for a data.frame (to conform with R's default). To supress the significance codes, use \code{signifCode=NA} or \code{signifCode=NULL}.}

\item{label}{(Tex only.) Character scalar. The label of the Latex table.}

\item{float}{(Tex only.) Logical. By default, if the argument \code{title} or \code{label} is provided, it is set to \code{TRUE}. Otherwise, it is set to \code{FALSE}.}

\item{subtitles}{Character vector of the same length as the number of models to be displayed. If provided, subtitles are added underneath the dependent variable name.}

\item{fixef_sizes}{(Tex only.) Logical, default is \code{FALSE}. If \code{TRUE} and fixed-effects were used in the models, then the number of "individuals" per fixed-effect dimension is also displayed.}

\item{fixef_sizes.simplify}{Logical, default is \code{TRUE}. Only used if \code{fixef_sizes = TRUE}. If \code{TRUE}, the fixed-effects sizes will be displayed in parentheses instead of in a separate line if there is no ambiguity (i.e. if the size is constant across models).}

\item{yesNoFixef}{(Tex only.) A character vector of length 1 or 2. Default is \code{c("Yes", "No")}. This is the message displayed when a given fixed-effect is (or is not) included in a regression. If \code{yesNoFixef} is of length 1, then the second element is the empty string.}

\item{keepFactors}{Logical, default is \code{TRUE}. If \code{FALSE}, then factor variables are displayed as fixed-effects and no coefficient is shown.}

\item{family}{Logical, default is missing. Whether to display the families of the models. By default this line is displayed when at least two models are from different families.}

\item{powerBelow}{(Tex only.) Integer, default is -5. A coefficient whose value is below \code{10**(powerBelow+1)} is written with a power in Latex. For example \code{0.0000456} would be written \code{4.56$\\times 10^{-5}$} by default. Setting \code{powerBelow = -6} would lead to \code{0.00004} in Latex.}

\item{interaction.combine}{(Tex only.) Character scalar, defaults to \code{" $\\times$ "}. When the estimation contains interactions, then the variables names (after aliasing) are combined with this argument. For example: if \code{dict = c(x1="Wind", x2="Rain")} and you have the following interaction \code{x1:x2}, then it will be renamed (by default) \code{Wind $\\times$ Rain} -- using \code{interaction.combine = "*"} would lead to \code{Wind*Rain}.}

\item{depvar}{(Data frame only.) Logical, default is missing. Whether a first line containing the dependent variables should be shown. By default, the dependent variables are shown only if they differ across models or if the argumen \code{file} is not missing.}
}
\value{
If \code{tex = TRUE}, the lines composing the Latex table are returned invisibly while the table is directly prompted on the console.

If \code{tex = FALSE}, the data.frame is directly returned. If the argument \code{file} is not missing, the \code{data.frame} is returned invisibly.
}
\description{
Aggregates the results of multiple estimations and displays them in the form of either a Latex table or a \code{data.frame}.
}
\details{
The function \code{esttex} is equivalent to the function \code{etable} with argument \code{tex = TRUE}.

The function \code{esttable} is equivalent to the function \code{etable} with argument \code{tex = FALSE}.
}
\section{Functions}{
\itemize{
\item \code{esttex}: Exports the results of multiple \code{fixest} estimations in a Latex table.

\item \code{esttable}: Facility to display the results of multiple \code{fixest} estimations.
}}

\section{Arguments keep, drop and order}{

The arguments \code{keep}, \code{drop} and \code{order} use regular expressions. If you are not aware of regular expressions, I urge you to learn it, since it is an extremely powerful way to manipulate character strings (and it exists across most programming languages).

For example drop = "Wind" would drop any variable whose name contains "Wind". Note that variables such as "Temp:Wind" or "StrongWind" do contain "Wind", so would be dropped. To drop only the variable named "Wind", you need to use \code{drop = "^Wind$"} (with "^" meaning beginning, resp. "$" meaning end, of the string => this is the language of regular expressions).

Although you can combine several regular expressions in a single character string using pipes, \code{drop} also accepts a vector of regular expressions.

You can use the special character "!" (exclamation mark) to reverse the effect of the regular expression (this feature is specific to this fonction). For example \code{drop = "!Wind"} would drop any variable that does not contain "Wind".

You can use the special character "%" (percentage) to make reference to the original variable name instead of the aliased name. For example, you have a variable named \code{"Month6"}, and use a dictionary \code{dict = c(Month6="June")}. Thus the variable will be displayed as \code{"June"}. If you want to delete that variable, you can use either \code{drop="June"}, or \code{drop="%Month6"} (which makes reference to its original name).

The argument \code{order} takes in a vector of regular expressions, the order will follow the elments of this vector. The vector gives a list of priorities, on the left the elements with highest priority. For example, order = c("Wind", "!Inter", "!Temp") would give highest priorities to the variables containing "Wind" (which would then appear first), second highest priority is the variables not containing "Inter", last, with lowest priority, the variables not containing "Temp". If you had the following variables: (Intercept), Temp:Wind, Wind, Temp you would end up with the following order: Wind, Temp:Wind, Temp, (Intercept).
}

\examples{

aq = airquality
aq$Month = factor(aq$Month)

est1 = feols(Ozone ~ Month / Wind + Temp, data = aq)
est2 = feols(Ozone ~ Wind + Temp | Month, data = aq)

# Displaying the two results in a single table
etable(est1, est2)

# keep/drop: keeping only interactions
etable(est1, est2, keep = ":")
# or using drop  (see regexp help):
etable(est1, est2, drop = "^[[:alnum:]]+$")

# keep/drop: dropping interactions
etable(est1, est2, drop = ":")
# or using keep ("!" reverses the effect):
etable(est1, est2, keep = "!:")

# order: Wind variable first, intercept last
etable(est1, est2, order = c("Wind", "Month"))
etable(est1, est2, order = c("^Wind", "Wind", "Month"))
# Interactions, then Intercept, last ("!" reverses the effect)
etable(est1, est2, order = c("!Int", "!:"))

# dict + keep/drop/order: using "\%" to match the original names
dict = c("Month5"="May", "Month6"="Jun", "Month7"="Jul",
         "Month8"="Aug", "Month9"="Sep")
etable(est1, est2, tex = TRUE, dict = dict)
# keeping only June and July
etable(est1, est2, tex = TRUE, dict = dict, keep = c("\%Month6", "Jul"))
# All months variabes first
etable(est1, est2, tex = TRUE, dict = dict, order = c("\%Month"))

# signifCode
etable(est1, est2, signifCode = c(" A"=0.01, " B"=0.05, " C"=0.1,
                                  " D"=0.15, " F"=1))

# fitstat
etable(est1, est2, fitstat = ~r2+ar2+apr2+war2)

# Adding a dictionnary (Tex only)
dict = c(Month5="May", Month6="Jun", Month7="Jul", Month8="Aug", Month9="Sep")
etable(est1, est2, dict = dict, tex = TRUE)

}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Use \code{\link[fixest]{summary.fixest}} to see the results with the appropriate standard-errors, \code{\link[fixest]{fixef.fixest}} to extract the fixed-effects coefficients.
}
\author{
Laurent Berge
}
