% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createInitialSample.R
\name{createInitialSample}
\alias{createInitialSample}
\title{Create Initial Sample}
\usage{
createInitialSample(n.obs, dim, control)
}
\arguments{
\item{n.obs}{[\code{integer(1)}]\cr
Number of observations.}

\item{dim}{[\code{integer(1)}]\cr
Number of dimensions.}

\item{control}{[\code{list}]\cr
Control argument. For further information refer to the details.}
}
\value{
[\code{\link{matrix}}].\cr
  A matrix, consisting of \code{n.obs} rows of \code{dim}-dimensional
  observations.
}
\description{
Convenient helper function, which creates an initial sample - either based
  on random (uniform) sampling or using latin hypercube sampling.
}
\details{
Per default, this function will produce \code{n.obs} observations of size
  \code{dim} in the range from 0 to 1. If you want to create a more specific
  initial sample, the following control arguments might be helpful:
  \itemize{
    \item{\code{init_sample.type}}: Should the initial sample be created
    based on random uniform sampling (\code{"random"}) or on a latin hypercube
    sample (\code{"lhs"})? The default is \code{"random"}.
    \item{\code{init_sample.lower}}: The lower bounds of the initial sample.
    Either a vector of size \code{dim} or a scalar (if all lower bounds are
    identical). The default is \code{0}.
    \item{\code{init_sample.upper}}: The upper bounds of the initial sample.
    Either a vector of size \code{dim} or a scalar (if all upper bounds are
    identical). The default is \code{1}.
  }
}
\examples{
# (1) create a simple initial sample:
X = createInitialSample(300, 5)
summary(X)

# (2) create a more specific initial sample:
ctrl = list(init_sample.type = "lhs",
  init_sample.lower = c(-5, 2, 0),
  init_sample.upper = 10)
X = createInitialSample(200, 3, control = ctrl)
summary(X)

}

