library(tidyr)

context("test remove_k")

test_that("remove_k works", {
  result <-
    structure(
      list(
        V1 = c(
          "",
          "A",
          "a1",
          "",
          "",
          "Total a1",
          "a2",
          "",
          "",
          "Total a2",
          "Total general"
        ),
        V2 = c("", "B", "b1", "b2",
               "b3", "", "b1", "b2", "b3", "", ""),
        V3 = c(
          "e1",
          "d1",
          "4331232344,45",
          "970,96",
          "93,20",
          "1506,68",
          "3533,70",
          "1561,52",
          "1268,08",
          "6363,30",
          "7869,98"
        ),
        V4 = c(
          "",
          "d2",
          "1232344,46",
          "964,57",
          "",
          "1115,53",
          "1034,02",
          "687,32",
          "1135,90",
          "2857,24",
          "3972,77"
        ),
        V5 = c(
          "Total e1",
          "",
          "593,48",
          "1935,53",
          "93,20",
          "2622,21",
          "4567,72",
          "2248,84",
          "2403,98",
          "9220,54",
          "11842,75"
        ),
        V6 = c(
          "e2",
          "d1",
          "1223,64",
          "586,75",
          "1473,56",
          "3283,95",
          "2455,20",
          "1927,10",
          "1063,01",
          "5445,31",
          "8729,26"
        ),
        V7 = c(
          "",
          "d2",
          "69,96",
          "",
          "",
          "69,96",
          "2001232344,35",
          "85,26",
          "307,94",
          "947,00",
          "1016,96"
        ),
        V8 = c(
          "Total e2",
          "",
          "1293,60",
          "586,75",
          "1473,56",
          "3353,91",
          "3009,00",
          "2012,36",
          "1370,95",
          "6392,31",
          "9746,22"
        ),
        V9 = c(
          "Total general",
          "",
          "1887,08",
          "2522,28",
          "1566,76",
          "5976,12",
          "7576,72",
          "4261,20",
          "3774,93",
          "15612,85",
          "21588,97"
        )
      ),
      page = "inst/extdata/csv/set_v_ie.csv",
      n_col_labels = 2,
      n_row_labels = 2,
      n_extract = 0,
      row.names = 65:75,
      class = c("data.frame",
                "pivot_table")
    )
  pt <- list_pt_ie[[4]]
  pt[4, 3] <- "4.331.232.344,45"
  pt[4, 4] <- "1.232.344,46"
  pt[8, 7] <- "2.001.232.344,35"
  pt <-
    pt %>%
    remove_top(1) %>%
    define_labels(n_col = 2, n_row = 2) %>%
    remove_k()
  expect_equal(pt, result)
})
