% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{get_page}
\alias{get_page}
\alias{get_page.pivot_table}
\title{Get the page information of a pivot table}
\usage{
get_page(pt)

\method{get_page}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A vector of strings.
}
\description{
Get the page information associated with the pivot table represented by the
object.
}
\details{
Each pivot table implements a report. The pivot table page represents the
context of that report. It is useful when we work with several pivot tables
with the same structure: for example, the page can allow us to differentiate
their origin, date or author. This information is often included in the file
name, sheet name, or cells attached to the pivot table.
}
\examples{
page <- pt_ex |> get_page()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table definition functions: 
\code{\link{define_labels}()},
\code{\link{pivot_table}()},
\code{\link{set_page}()}
}
\concept{pivot table definition functions}
