\name{salmonellaTA98}
\alias{salmonellaTA98}
\title{Salmonella reverse mutagenicity assay}
\usage{data("salmonellaTA98")}
\description{
  Data on Ames Salmonella reverse mutagenicity assay.
}

\format{
  This data frame contains the following columns:
  \describe{
    \item{x}{dose levels of quinoline}
    \item{y}{numbers of revertant colonies of TA98 Salmonella observed on
      each of three replicate plates testes at each of six dose levels of
      quinolinediameter 4.5 feet of the ground, inches}
  }
}

\details{
  This data set is taken from package \pkg{dispmod} provided by Luca
  Scrucca.
}

\source{
  Margolin, B.J., Kaplan, N. and Zeiger, E. (1981) Statistical
  analysis of the Ames Salmonella/microsome test,
  \emph{Proc. Natl. Acad. Sci. USA}, \bold{76}, 3779--3783.
}

\references{
  Breslow, N.E. (1984), Extra-Poisson variation in log-linear
  models, \emph{Applied Statistics}, \bold{33}, 38--44.

  Wang, P., Puterman, M.L., Cockburn, I.M., and Le, N.D. (1996) Mixed
  Poisson regression models with covariate dependent rates,
  \emph{Biometrics}, \bold{52}, 381--400.
}

\examples{
data("salmonellaTA98")
salmonMix <- stepFlexmix(y~1,
                         data=salmonellaTA98, 
                         model=FLXMRglmfix(family="poisson", 
                           fixed=~x + log(x + 10)),                        
                         k=2, nrep=5)
salmonMix.pr <- predict(salmonMix, newdata=salmonellaTA98)
plot(y~x, data=salmonellaTA98, 
     pch=as.character(cluster(salmonMix)), 
     ylim=range(c(salmonellaTA98$y, unlist(salmonMix.pr))))
for (i in 1:2) lines(salmonellaTA98$x, salmonMix.pr[[i]], lty=i)
}

\keyword{datasets}
