% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{compose}
\alias{compose}
\alias{mk_par}
\title{Define flextable displayed values}
\usage{
compose(x, i = NULL, j = NULL, value, part = "body")

mk_par(x, i = NULL, j = NULL, value, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{column selection}

\item{value}{a call to function \code{\link{as_paragraph}}.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Modify flextable displayed values. Function is
handling complex formatting as well as image insertion.
}
\section{Illustrations}{


\if{html}{\figure{fig_compose_1.png}{options: width=80\%}}
}

\section{mk_par}{

Function \code{mk_par} is another name for \code{compose} as
there is an unwanted conflict with package \code{purrr}.
}

\examples{
library(officer)
ft <- flextable(head( mtcars, n = 10))
ft <- compose(ft, j = "carb", i = ~ drat > 3.5,
  value = as_paragraph("carb is ", as_chunk( sprintf("\%.1f", carb)) )
  )
ft <- autofit(ft)
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()}
}
\concept{cells formatters}
