% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_chunk.R
\name{append_chunks}
\alias{append_chunks}
\title{append chunks to flextable content}
\usage{
append_chunks(x, i = NULL, j = NULL, ..., part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{column selection}

\item{...}{chunks to be appened, see \code{\link[=as_chunk]{as_chunk()}}, \code{\link[=gg_chunk]{gg_chunk()}} and other
chunk elements for paragraph.}

\item{part}{partname of the table (one of 'body', 'header', 'footer')}
}
\description{
append chunks (for example chunk \code{\link[=as_chunk]{as_chunk()}})
in a flextable.
}
\examples{
library(flextable)

f1 <- function(x) {
  formatC(x, digits = 1,
          format = "f")
}
f2 <- function(x) {
  paste0(
    " (",
    formatC(x, digits = 1,
            format = "f"), ")")
}

ft_1 <- flextable(
  data = head(mtcars),
  col_keys = c("am", "gear", "carb", "mycol")
)
ft_1 <- merge_v(ft_1, j = "am")
ft_1 <- valign(ft_1, valign = "top")
ft_1 <- theme_vanilla(ft_1)
ft_1 <- mk_par(ft_1,
  j = "mycol", part = "body",
  value = as_paragraph(
    as_chunk(mpg, formatter = f1), " ",
    colorize(as_chunk(wt, formatter = f2), "gray")
  )
)

ft_1 <-
  append_chunks(ft_1,
    i = 1, j = "mycol", part = "header",
    as_chunk("mpg "),
    colorize(as_bracket("wt"), "gray")
  )

ft_1 <- align(
  x = ft_1, j = c("am", "gear", "carb"),
  align = "center", part = "all")
ft_1 <- align(
  x = ft_1, j = "mycol",
  align = "right", part = "all")

ft_1 <- autofit(ft_1)

ft_1
}
