% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_header}
\alias{add_header}
\title{Add column values as new lines in header}
\usage{
add_header(x, top = TRUE, ..., values = NULL)
}
\arguments{
\item{x}{a flextable object}

\item{top}{should the rows be inserted at the top or the bottom.}

\item{...}{named arguments (names are data colnames) of values
to add. It is important to insert data of the same type as the
original data, otherwise it will be transformed (probably
into strings if you add a \code{character} where a \code{double} is expected).
This makes possible to still format cell contents with the \verb{colformat_*}
functions, for example \code{\link[=colformat_num]{colformat_num()}}.}

\item{values}{a list of name-value pairs of labels or values,
names should be existing col_key values. This argument can be used
instead of \code{...} for programming purpose (If \code{values} is
supplied argument \code{...} is ignored).}
}
\description{
The function adds a list of values to be inserted as
new rows in the header. The values are inserted in
existing columns of the input data of the flextable.
Rows can be inserted at the top or the bottom of
the header.

If some columns are not provided, they will be replaced by
\code{NA} and displayed as empty.

\if{html}{\out{
<img src="https://www.ardata.fr/img/flextable-imgs/flextable-016.png" alt="add_header illustration" style="width:100\%;">
}}
}
\note{
when repeating values, they can be merged together with
function \code{\link[=merge_h]{merge_h()}} and \code{\link[=merge_v]{merge_v()}}.
}
\examples{
library(flextable)

fun <- function(x) {
  paste0(
    c("min: ", "max: "),
    formatC(range(x))
  )
}
new_row <- list(
  Sepal.Length = fun(iris$Sepal.Length),
  Sepal.Width =  fun(iris$Sepal.Width),
  Petal.Width =  fun(iris$Petal.Width),
  Petal.Length = fun(iris$Petal.Length)
)

ft_1 <- flextable(data = head(iris))
ft_1 <- add_header(ft_1, values = new_row, top = FALSE)
ft_1 <- append_chunks(ft_1, part = "header", i = 2, )
ft_1 <- theme_booktabs(ft_1, bold_header = TRUE)
ft_1 <- align(ft_1, align = "center", part = "all")
ft_1
}
\seealso{
Other functions to add rows in a flextable: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions to add rows in a flextable}
