% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{flimobjective}
\alias{flimobjective}
\title{Objective function minimized by flimo}
\usage{
flimobjective(Theta, quantiles, data, dsumstats, simulatorQ)
}
\arguments{
\item{Theta}{1D array. parameters for the simulations.}

\item{quantiles}{2D array containing values drawn in U(0,1).
Row number = number of simulations.
Column number = number of random variables to draw in one simulation.}

\item{data}{1D array containing the observations.}

\item{dsumstats}{Function computing the distance between simulations and data
of form dsumstats(simulations, data) where
simulations : 2D array and data : 1D array.
ncol(simulations) = length(data) mandatory.}

\item{simulatorQ}{Function of type simulatorQ(Theta, quantiles)
where Theta is the parameter set for the simulations
and quantiles are drawn in U(0,1).
See README for details.}
}
\value{
Numeric value. Distance between summary statistics of data
and simulations w.r.t. Theta.
}
\description{
Computes the summary statistics between simulations w.r.t.
Theta and data. This function is to be minimized by flimoptim.
}
\examples{

quantiles <- matrix(runif(50), nrow = 10)

data <- rep(100, 5)

dsumstats <- function(simulations, data){
mean_simu <- mean(rowMeans(simulations))
mean_data <- mean(data)
(mean_simu-mean_data)^2
}

simulatorQ <- function(Theta, quantiles){
qpois(quantiles, lambda = Theta)
}

flimobjective(100, quantiles, data, dsumstats, simulatorQ)

}
