
#utils::globalVariables(c("testType", "statTest","i","stratum","permSpace"))
#out <- sys.frame(sys.nframe())

####### deals with NA in permSpace
.fixPermT <- function(permT){
  if(any(is.na(permT))){
    permT[,apply(permT,2,function(x) all(is.na(x)))]=0
    permT=permT[apply(permT,1,function(x)!any(is.na(x))),,drop=TRUE]
  }
  permT
}
######## match the setting for permutation 
.PermSpaceMatchInput <- function(perms) {
if (!is.list(perms)) {
		#the whole matrix of random permutaitons is provided
		if (is.matrix(perms)) return(list(permID = perms, B=nrow(perms) , n= ncol(perms), seed=NA))		
		#only the number of random permutaitons is provided
		if (is.numeric(perms)) return(list(permID = NULL, B=perms ,seed=NA))
		
      } else return(perms)  #hopefully there are all elements, migliorare la funzione qui
}	  



############################
# Calculates signs flips of a vector of N elements.
# perms is the number of flips; if perms > number of all possible flips, then compute the complete space
############################
make.signSpace <- function(N,perms) {
    perms=.PermSpaceMatchInput(perms)
	perms$n=N
	if(is.null(perms$permID)){
		if (2^(N-1) <= perms$B) {
		    # all permutations if possible and if no stratas
			#random <- FALSE
		 # require(e1071)
			if(N>1){
				perms$permID <-cbind(0,bincombinations(N-1))
				perms$permID= perms$permID[-1,]
				perms$permID [which(perms$permID ==1)] <- -1
				perms$permID [which(perms$permID ==0)] <- 1
			} else {
				print("The function needs N>1")
				return()
				}
				perms$seed=NA
				perms$B=(2^(N)-1)
				if(is.null(perms$rotFunct)) perms$rotFunct <- function(i) (permSpace$permID[i,]*data$Y)
		} else {
			#otherwise random permutations
			#if (is.na(perms$seed)) perms$seed <- round(runif(1)*1000)
			if (!is.na(perms$seed)) set.seed(perms$seed)
			perms$permID <- matrix(1 - 2 * rbinom(N * (perms$B%/%2),1, 0.5), (perms$B%/%2), N)
			if(is.null(perms$rotFunct)) perms$rotFunct <- function(i) (permSpace$permID[i,]*data$Y)
		}	
	} else if(is.null(perms$rotFunct)) perms$rotFunct <- function(i) (permSpace$permID[i,]*data$Y)
	perms
}

############################
# Calculates permutations space of a vector Y. 
# perms is the number of permutations; if perms > number of all permutations, then compute the complete space
############################
make.permSpace <- function(IDs,perms,return.permIDs=FALSE,testType="permutation",Strata=NULL) {
  perms=.PermSpaceMatchInput(perms)
	if(tolower(testType)=="rotation") {
		perms=.make.RotSpace(IDs,perms)
		perms$type="rotation"
	} else if(tolower(testType)=="simulation") {
		perms=.make.SimSpace(IDs,perms)
		perms$type="simulation"
	} else 	{ ## then standard permutations
		perms=.make.PermSpace(IDs,perms,return.permIDs=return.permIDs,Strata=Strata)
		perms$type="permutation"
  }
  if(!is.na(perms$seed)) set.seed(perms$seed)
  environment(perms$rotFunct) <- sys.frame(sys.parent())
  perms
}

##########################
##make random permutations of indices
##########################
.make.PermSpace <- function(IDs,perms,return.permIDs=FALSE,Strata=NULL,forceRandom=FALSE){
  if(is.null(return.permIDs)) return.permIDs=FALSE
     if(length(IDs)==1) IDs=1:IDs
	if(is.null(Strata)){
				perms$n=length(IDs)
				allperms=npermutations(IDs)
				# all permutations if possible
				if ( ( allperms <= perms$B) && (!forceRandom)) {
					#random <- FALSE
					perms$permID <- t(allpermutations(IDs))[-1,]
					perms$seed=NA
					perms$B=(allperms-1)
					perms$rotFunct <- function(i) (data$Y[perms$permID[i,],,drop=FALSE])
				} else {
					# otherwise random permutations
					# if (is.na(perms$seed))
						# perms$seed <- round(runif(1)*1000)
					# set.seed(perms$seed)
					if (!is.na(perms$seed))	set.seed(perms$seed)
					
					if(!return.permIDs) {
						perms$rotFunct <- function(i) (data$Y[sample(perms$n),,drop=FALSE])
					} else {
						perms$permID <- t(replicate(perms$B, IDs[sample(perms$n)]))
						perms$rotFunct <- function(i) (data$Y[perms$permID[i,],,drop=FALSE])
						}
				}
		perms
	} else #Strata are present
	{	
		strataSz=cumsum(table(Strata))
		strataLable= unique(Strata)
		space=.make.PermSpace(IDs=IDs[Strata==strataLable[1]],perms=perms,return.permIDs=TRUE,Strata=NULL,forceRandom=TRUE)
		for(i in 2:length(strataSz))
		space$permID =cbind(space$permID,.make.PermSpace(IDs=IDs[Strata==strataLable[i]],perms=perms,return.permIDs=TRUE,Strata=NULL,forceRandom=TRUE)$permID)
	}
}


############################
# rotation space of a vector Y. 
# perms is the number of permutations; seed the seed for random number generation, rotFunct the function to generate the random rotations
############################
.make.RotSpace <- function(Y,perms) {

	##then it is a list anyway now
	perms <- perms[intersect(names(perms),c("B","seed","n","rotFunct"))]
	if(is.null(perms$n))  perms$n <- length(Y)
	if(is.null(perms$B))  perms$B <- 1000
	#if(is.null(perms$seed) || is.na(perms$seed) )  perms$seed <- round(runif(1)*1000)
	if(is.null(perms$rotFunct))  
		perms$rotFunct  <- function(i) { #argument is not used now
			R <- matrix(rnorm(perms$n^2),ncol=perms$n) 
				R <- qr.Q(qr(R, LAPACK = TRUE))
				#the above does not work properly. same for LAPACK = FALSE.
      #the following is better:
			#R <- svd(R)$u
 			return(R%*%data$Y)
		}

	return(perms)
	
}	  


######################################
.make.SimSpace <- function(covs,perms) {

	##then it is a list anyway now
	perms <- perms[intersect(names(perms),c("B","seed","n","rotFunct"))]
	if(is.null(perms$n))  perms$n <- nrow(covs)
	if(is.null(perms$B))  perms$B <- 1000
	#if(is.null(perms$seed) || is.na(perms$seed) )  perms$seed <- round(runif(1)*1000)
	perms$p=ncol(covs)
  if(perms$p==1){
    perms$rots=array(1,c(nrow(covs),1))
  } else {
  	ei=eigen(covs[1,,]); 
  	ei$values[ei$values<0]=0; 
  	temp=diag(sqrt(ei$values))%*%t(ei$vectors)
    perms$rots=matrix(,nrow(covs),length(temp))
    perms$rots[1,]=temp
    rm(temp,ei)  
  	for(i in 2:nrow(covs)) {
      ei=eigen(covs[i,,]); 
      ei$values[ei$values<0]=0; 
      perms$rots[i,]=diag(sqrt(ei$values))%*%t(ei$vectors)
  	}
  }
	#now covs is a list of length n
	rm(covs)
	if(is.null(perms$rotFunct))  
		perms$rotFunct  <- function(i) { #argument is not used yet
			R <- rnorm(nrow(perms$rots))*perms$rots
			R <- array(R,c(perms$p,perms$n,perms$p))
			R <- apply(R,c(2,3),sum)
		}
	return(perms)
}	  

############################
# Iterative function calculates all permutations of a vector
# values: vector of all unique values
# multiplicity: multiplicity of each value
############################
.allpermutations <- function(values, multiplicity) {

  if (length(values)==1) {
    out <- values
  } else {
    n <- sum(multiplicity)
    out <- matrix(0 , n, .npermutations(multiplicity))
    where <- 0
    for (i in 1:length(values)) {
      if (multiplicity[i] == 1) {
        newmult <- multiplicity[-i]
        newvals <- values[-i]
      } else {
        newmult <- multiplicity
        newmult[i] <- newmult[i] - 1
        newvals <- values
      }
      range <- where + seq_len(.npermutations(newmult))
      where <- range[length(range)]
      out[1,range] <- values[i]
      out[2:n, range] <- .allpermutations(newvals, newmult)
    }
  }
  out
}

############################
# Iterative function counts all permutations of a vector
# values: vector of all unique values
# multiplicity: multiplicity of each value
############################
.npermutations <- function(multiplicity) {
  round(exp(lfactorial(sum(multiplicity)) - sum(lfactorial(multiplicity))))
}

############################
# Counts all permutations of a vector y
# user-friendly version of .npermutations()
############################
npermutations <- function(Y) {
  .npermutations(table(Y))
}

############################
# Calculates all permutations of a vector y
# user-friendly version of .allpermutations()
############################
allpermutations <- function(Y) {
  values <- unique(Y)
  multiplicity <- colSums(outer(Y, values, "=="))
  .allpermutations(values, multiplicity)
}


##########
#compute p-value space P from statistic space T (the percentile of the statistic T column-wise)
t2p<-function(T, obs.only=TRUE, tail = 1){  
    
	if(!missing(tail))	T = .setTail(T,tail)
	
	if(!is.matrix(T)) {T<-as.matrix(T)}
	if(obs.only) { 
		P=matrix(apply(T,2,function(permy)mean(permy>=permy[1],na.rm=TRUE)),1,ncol(T))
		rownames(P)="p-value"
	}
	else{
		#oth<-seq(1:length(dim(T)))[-1]
    T <- .fixPermT(T)
		B<-nrow(T)
		P=apply(-T,2,rank,ties.method ="max",na.last="keep")/B
		P=as.matrix(P)
		rownames(P)=c("p-obs",paste("p-*",1:(B-1),sep=""))
	}
	colnames(P)=colnames(T)
	return(P)
}


############### standardize permT space. used in maxTstd and
.t2stdt <- function(permT,obs.only=TRUE){ return(t(t((permT[1:(nrow(permT)^(!obs.only)),]))/apply(permT,2,sd,na.rm=TRUE)))}
