% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one-sample-stats.R
\name{one-sample-stats}
\alias{one-sample-stats}
\alias{stat_max}
\title{Test Statistics for the One-Sample Problem}
\usage{
stat_max(data, flips)
}
\arguments{
\item{data}{A list storing the sample from which the user wants to make
inference.}

\item{flips}{A numeric vectors of \code{-1}s and \code{1}s to be used to randomly flip
some data points around the center of symmetric of the distribution of the
sample.}
}
\value{
A numeric value evaluating the desired test statistic.
}
\description{
This is a collection of functions that provide test statistics to be used
into the permutation scheme for performing one-sample testing.
}
\examples{
n <- 10
x <- as.list(rnorm(n))
flips <- sample(c(-1, 1), n, replace = TRUE)
stat_max(x, flips)
}
