% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_fc.R
\name{as_fc}
\alias{as_fc}
\title{as_fc}
\usage{
as_fc(
  .data,
  label = "Initial dataframe",
  text_pattern = "{label}\\n{N}",
  just = "center",
  text_color = "black",
  text_fs = 8,
  bg_fill = "white",
  border_color = "black",
  hide = FALSE
)
}
\arguments{
\item{.data}{Data frame that we want to show the number of rows.}

\item{label}{Character with the text that will be shown in the box.}

\item{text_pattern}{Structure that will have the text in the box. It recognizes label, n, N and perc within brackets. For default it is "\{label\}\\n\{N\}".}

\item{just}{Justification for the text: left, center or right. Default is center.}

\item{text_color}{Color of the text. It is black by default.}

\item{text_fs}{Font size of the text. It is 8 by default.}

\item{bg_fill}{Box background color. It is white by default.}

\item{border_color}{Box border color. It is black by default.}

\item{hide}{Logical value to hide the initial box or not. Default is FALSE. hide = TRUE can only be combined with fc_split().}
}
\value{
List with the dataset and the initialized flowchart parameters.
}
\description{
This function allows to initialize a flow chart given any database. It will create a fc object showing the number of rows of the database.
}
\examples{
clinic_patient |>
as_fc(label = "All patients") |>
fc_draw()

}
