% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_export.R
\name{fc_export}
\alias{fc_export}
\title{fc_export}
\usage{
fc_export(
  object,
  filename,
  path = NULL,
  format = NULL,
  width = NA,
  height = NA,
  units = "px",
  res = 100
)
}
\arguments{
\item{object}{fc object that we want to export.}

\item{filename}{File name to create on disk.}

\item{path}{Path of the directory to save plot to: path and filename are combined to create the fully qualified file name. Defaults to the working directory.}

\item{format}{Format to export the image. One of 'png', 'jpeg' or 'tiff'. If NULL (default), the format is guessed based on the filename extension.}

\item{width, height}{Plot size in units expressed by the `units` argument. Default is 600px.}

\item{units}{One of the following units in which the width and height arguments are expressed: "in", "cm", "mm" or "px". Default is "px".}

\item{res}{The nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer. Also used for units other than the default, and to convert points to pixels. Default is 100.}
}
\value{
Invisibly returns the same object that has been given to the function.
}
\description{
This function allows you to export the drawn flowchart to the most popular image formats (png, jpeg, tiff).
}
\examples{
\dontrun{
clinic_patient |>
  as_fc(label = "Available patients") |>
  fc_filter(age >= 18 & consent == "Yes", label = "Patients included", show_exc = TRUE) |>
  fc_split(group) |>
  fc_filter(n_visits == 2, label = "Two visits available", show_exc = TRUE) |>
  fc_split(marker_alt, label = c("Marker not alterated", "Marker alterated")) |>
  fc_draw() |>
  fc_export("flowchart.png")

}
}
