% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_fitting_lin.R
\name{flux_fitting_lin}
\alias{flux_fitting_lin}
\title{linear fit to gas concentration over time}
\usage{
flux_fitting_lin(
  conc_df,
  start_cut = 0,
  end_cut = 0,
  start_col = "f_start",
  end_col = "f_end",
  datetime_col = "f_datetime",
  conc_col = "f_conc",
  fluxid_col = "f_fluxID"
)
}
\arguments{
\item{conc_df}{dataframe of gas concentration over time}

\item{start_cut}{time to discard at the start of the measurements
(in seconds)}

\item{end_cut}{time to discard at the end of the measurements (in seconds)}

\item{start_col}{column with datetime when the measurement started}

\item{end_col}{column with datetime when the measurement ended}

\item{datetime_col}{column with datetime of each concentration measurement}

\item{conc_col}{column with gas concentration data}

\item{fluxid_col}{column with ID of each flux}
}
\value{
a df with the modeled gas concentration, slope, intercept,
std error, r square and p value of the linear model
}
\description{
fits a linear model to the gas concentration over time
}
