% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality_exp.R
\name{flux_quality_exp}
\alias{flux_quality_exp}
\title{quality assessment for the slopes estimated by flux_fitting}
\usage{
flux_quality_exp(
  slopes_df,
  weird_fluxes_id = c(),
  force_ok_id = c(),
  b_col = "f_b",
  rmse_threshold = 25,
  cor_threshold = 0.5,
  b_threshold = 1
)
}
\arguments{
\item{slopes_df}{dataset containing slopes, fluxID,
and parameters of the exponential expression}

\item{weird_fluxes_id}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok_id}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{b_col}{column containing the b parameter of the exponential expression}

\item{rmse_threshold}{threshold for the RMSE of each flux above
which the fit is considered unsatisfactory}

\item{cor_threshold}{threshold for the correlation coefficient
of gas concentration with time below which the correlation
is considered non significant}

\item{b_threshold}{threshold for the b parameter. Defines a window
with its opposite inside which the fit is considered good enough.}
}
\value{
same dataframe with added flag and corrected slopes columns
}
\description{
indicates if fluxes should be discarded or replaced by 0
according to parameters set by user.
flux_quality_lm is for the model of the lm family.
flux_quality_exp is for the exponential model.
}
