##' Tuning paramater selection
##'
##' Select tuning parameter via AIC, BIC or GIC from objects generated by 
##' \code{path.fmrHP}.
##' @usage 
##' select.tuning(object, figure = FALSE, criteria = c("BIC", "GIC", "AIC"))
##' @param object Object generated from \code{path.fmrHP}.
##' @param figure incidator for showing plot of information criteria.
##' @param criteria information criteria for selection of tuning parameter.
##' @return list of parameters of selected model.
##' @export

select.tuning <- function(object, figure = FALSE, criteria = c("BIC", "GIC", "AIC")) {
  ## object from fmrHP function output
  criteria <- match.arg(criteria)
  p <- dim(object$B.hat)[1]
  k <- dim(object$B.hat)[2]
  ind <- seq_len(dim(object$B.hat)[3])
  # ind <- which(apply(object$B.hat != 0, 3, sum) < k * p / 2)
  select <- object$IC[, ind]
  if(figure == TRUE) {
    plot(t(object$IC[c("lambda", criteria), ]),
         xlab = expression(lambda), ylab = criteria, main = deparse(substitute(object)))
  }
  index <- which.min(select[criteria, ])
  output <-list(object$B.hat[, , ind, drop = FALSE][, , index], object$rho.hat[, ind, drop = FALSE][, index],
                object$pi.hat[, ind, drop = FALSE][, index], object$IC[, ind, drop = FALSE][, index])
  names(output) <- c("B", "rho", "prob", "info")
  output
}
