% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\title{PCA Plot of the Noise Score of Each Individual}
\usage{
plot(
  score,
  data,
  cl,
  geom.ind = "text",
  labelsize = 3,
  geom_point_size = 3,
  ...
)
}
\arguments{
\item{score}{a vector of values indicating the optential of being a noise.}

\item{data}{matrix or data frame with no label.}

\item{cl}{factor of true classifications of data set.}

\item{geom.ind}{as geom for observations, which can be set to "text", "point" and "none". The default is "text".}

\item{labelsize}{size of geom_text.}

\item{geom_point_size}{size of geom_point and geom_none.}

\item{...}{optional parameters to be passed to other methods.}
}
\value{
an plot of PCA with the noise score of each observation
}
\description{
This function plots the noise score for each observation
}
\examples{

data(iris)
out = fmf(Species~.,iris)
plot(out$noise_score, iris[,-1], iris[,1])

}
\author{
Wanwan Zheng
}
