% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmlcd.R
\name{fmlcd}
\alias{fmlcd}
\title{Estimates a Log-Concave Density}
\usage{
fmlcd(X, w = rep(1/nrow(X), nrow(X)), init = "", verbose = 0,
  intEps = 0.001, objEps = 1e-07, offset = 0.1, maxIter = 10000)
}
\arguments{
\item{X}{Matrix of data points (one sample per row)}

\item{w}{Vector of sample weights (default: uniform weights)}

\item{init}{String that sets the initialization approach. 'kernel' based on
kernel density, 'smooth' based on smooth log-concave density, '' compares
both and takes the optimal one. (default: '')}

\item{verbose}{Int determining the verboseness of the code; 0 = no output
to 3. (default: 0)}

\item{intEps}{Stopping criteria for the numerical integration accuracy
Optimization stops if both measurements are smaller than intEps and objEps
Modification of this value is not recommended. (default: 1e-3)}

\item{objEps}{Stopping criteria for the change in the objective function
Optimization stops if both measurements are smaller than intEps and objEps
Modification of this value is not recommended. (default: 1e-7)}

\item{offset}{Smaller values correspond to slower hyperplane reduction.
Offset should be a value smaller than 1. Modification of this value is not
recommended. (default: 1e-1)}

\item{maxIter}{Number of iterations in the main optimization (default: 1e4)}
}
\value{
Parametrization of f(x) in terms of hyperplanes and function
  evaluations y = log(f(x)) \item{aOpt, bOpt}{Analytically normalized
  parameters of f(x).} \item{logLike}{Log-likelihood of f(x)} \item{y}{Vector
  with values y_i = log(f(X_)) of the normalized density (\eqn{logLike =
  \sum(y_i)}).} \item{aOptSparse, bOptSparse}{Sparse parametrization
  normalized on the integration grid.}
}
\description{
\code{fmlcd} returns a MLE estimate of a log-concave
  density for \code{X}. After obtaining an initial parameter estimate the MLE
  objective with log-concavity and normalization constraint is optimized
  using a quasi-Newton approach for large scale optimization (BFGS-L). The
  logarithm of the optimal density f(x) is a piecewise-linear function. Its
  parametrization in terms of a set of hyperplanes is returned.
}
\examples{
# draw samples from normal distribution
X <- matrix(rnorm(200),100,2) 
# calculate parameters of convex hull of X
r <- calcCvxHullFaces(X)
# draw random parameters of 10 hyperplanes
a <- matrix(runif(10*2),10,2)
b <- runif(10)

# calculate parameters of convex hull of X
params <- correctIntegral(X,rep(0,2),a,b,r$cvh)
}
