% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_number.R
\name{print.factor.number}
\alias{print.factor.number}
\title{Print factor number}
\usage{
\method{print}{factor.number}(x, ...)
}
\arguments{
\item{x}{\code{factor.number} object}

\item{...}{not used}
}
\value{
NULL, printed to console
}
\description{
Prints a summary of a \code{factor.number} object
}
\examples{
library(fnets)
## Alessi, Barigozzi, and Capasso method for restricted models
abc <- factor.number(data.restricted, fm.restricted = TRUE)
print(abc)
plot(abc)

## Eigenvalue ratio method
er <- factor.number(data.restricted, method = "er", fm.restricted = TRUE)
print(er)
plot(er)

## Hallin and Liška method for unrestricted models
hl <- factor.number(data.unrestricted, fm.restricted = FALSE)
print(hl)
plot(hl)
}
\seealso{
\link[fnets]{factor.number}
}
