% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hessian0}
\alias{hessian0}
\title{Numerical Hessian}
\usage{
hessian0(f, x, args)
}
\arguments{
\item{f}{Function to differentiate.}

\item{x}{Vector at which to evaluate the Hessian.}

\item{args}{List of additional arguments from the function \code{richardson_args}.}
}
\value{
A list with the form of a \code{hessian_result} described in section "Hessian"
of the package vignette.
}
\description{
Numerical Hessian
}
\examples{
f = function(x) { sum(x^2) }
x0 = seq(1, 10, length.out = 5)
args = richardson_args()
hessian0(f, x0, args)
numDeriv::hessian(f, x0)

}
