% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfilter.R
\name{sfilter}
\alias{sfilter}
\title{fit the state-space model to \code{prefilter}-ed data}
\usage{
sfilter(x, model = c("rw", "crw"), time.step = 6, parameters = NULL,
  fit.to.subset = TRUE, optim = c("nlminb", "optim"),
  verbose = FALSE, inner.control = NULL)
}
\arguments{
\item{x}{Argos data passed through prefilter()}

\item{model}{specify which SSM is to be fit: "rw" or "crw"}

\item{time.step}{the regular time interval, in hours, to predict to.
Alternatively, a vector of prediction times, possibly not regular, must be
specified as a data.frame with id and POSIXt dates.}

\item{parameters}{a list of initial values for all model parameters and
unobserved states, default is to let sfilter specifiy these. Only play with
this if you know what you are doing...}

\item{fit.to.subset}{fit the SSM to the data subset determined by prefilter
(default is TRUE)}

\item{optim}{numerical optimizer to be used ("nlminb" or "optim")}

\item{verbose}{report progress during minimization}

\item{inner.control}{list of control settings for the inner optimization
(see ?TMB::MakeADFUN for additional details)}
}
\description{
generates initial values for model parameters and unobserved states;
structures data and initial values for C++ \code{TMB} template;
fits state-space model; minimises the joint log-likelihood via the selected
optimizer (\code{nlminb} or \code{optim}); structures and passes output
object to \code{fit_ssm}
}
\details{
called by \code{fit_ssm}. \code{sfilter} can only fit to an
individual track, use \code{fit_ssm} to fit to multiple tracks (see ?fit_ssm).
}
\examples{
data(ellie)
pf <- prefilter(ellie, vmax=10, ang=c(15,25), min.dt=120)
out <- sfilter(pf, model="rw", time.step=24)

}
