% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simfit.R
\name{simfit}
\alias{simfit}
\title{simulate animal tracks from a \code{fG_ssm} fit}
\usage{
simfit(
  x,
  what = c("fitted", "predicted"),
  reps = 1,
  cpf = FALSE,
  sim_only = FALSE
)
}
\arguments{
\item{x}{a compound \code{fG_ssm} model fit object (ignored if NULL)}

\item{what}{simulate fitted (typically irregular in time) or predicted
(typically regular in time) locations}

\item{reps}{number of replicate tracks to simulate from an \code{fG_ssm} model
fit object (ignored if x is NULL)}

\item{cpf}{logical; should simulated tracks return to their start point (ie. a central-place forager)}

\item{sim_only}{logical, do not include \code{fG_ssm} estimated location in output
(default is FALSE)}
}
\description{
simulate from the \code{rw} or \code{crw} process models to generate
either a set of x,y (or lon,lat) coordinates from a \code{fG_ssm} fit with length
equal to the number of observations used in the SSM fit.
}
\examples{
fit <- fit_ssm(ellie, vmax = 4, model = "crw", time.step = 48, control = ssm_control(se = FALSE))
trs <- simfit(fit, reps = 2, what = "predicted")
plot(trs)

}
