% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_rank.R
\name{foot_rank}
\alias{foot_rank}
\title{Rank and points predictions}
\usage{
foot_rank(
  object,
  data,
  teams = NULL,
  visualize = c("aggregated", "individual")
)
}
\arguments{
\item{object}{An object of class \code{\link[rstan]{stanfit}} or \code{stanFoot} as given by \code{stan_foot} function.}

\item{data}{A data frame containing match data with columns:
\itemize{
  \item \code{periods}:  Time point of each observation (integer >= 1).
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{teams}{An optional character vector specifying team names to include. If \code{NULL}, all teams are included.}

\item{visualize}{Type of plot, default is \code{"aggregated"}.}
}
\value{
Final rank tables and plots with the predicted points for the selected teams as given by the models fitted via the \code{stan_foot}
function.
}
\description{
Posterior predictive plots and final rank table for football seasons.
}
\details{
For Bayesian models fitted via \code{stan_foot} the final rank tables are computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches.
The dataset should refer to one or more seasons from a given national football league (Premier League, Serie A, La Liga, etc.).
}
\examples{

\dontrun{
library(dplyr)

data("italy")
italy_1999_2000<- italy \%>\%
dplyr::select(Season, home, visitor, hgoal,vgoal) \%>\%
dplyr::filter(Season == "1999"|Season=="2000")

colnames(italy_1999_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")

fit <- stan_foot(italy_1999_2000, "double_pois", iter = 200)
foot_rank(fit, italy_1999_2000)
foot_rank(fit, italy_1999_2000, visualize =  "individual")
 }

}
\author{
Leonardo Egidi \email{legidi@units.it}
}
