% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_psd.R
\name{geom_psd}
\alias{geom_psd}
\title{Plot the time series of particle size distribution.}
\usage{
geom_psd(
  df,
  labxyl = NULL,
  logy = TRUE,
  ybk = NULL,
  nlmt = NULL,
  csbk = pretty_breaks(4),
  trans = "identity",
  colsz = 1,
  fsz = 13,
  lsz = 0.4,
  tkl = 0.2
)
}
\arguments{
\item{df}{dataframe of particle size data: the first column of input is datetime; the other columns are number concentration (N, unit: #/cm3) or log number concentration (dN/dlogdp, unit: #/cm3) for each particle size channel. Column names of the other columns are the middle particle size for each particle size channel.}

\item{labxyl}{vector, Set the title of x axis, y axis, legend. The default vaule is NULL. Bquote grammer is accepted.}

\item{logy}{logical. Plot the data with log y axis. The default vaule is TRUE.}

\item{ybk}{numeric vector, breaks of y axis.}

\item{nlmt}{numeric value, range of particle number for colorscales of plot.}

\item{csbk}{numeric vector, breaks of color bar.}

\item{trans}{character string, "identity" or "log10". transformation of color bar breaks.}

\item{colsz}{numeric value, size of columns in plot.}

\item{fsz}{font size in plot.}

\item{lsz}{line size of panel border and axis in plot.}

\item{tkl}{tick length in plot.}
}
\value{
a plot for the time series of particle size distribution. \cr
}
\description{
Plot the time series of particle size distribution.
}
\examples{
\dontrun{ 
dn_table = read.delim(system.file("extdata", "smps.txt", package = "foqat"),
check.names = FALSE)
dn1_table=dn_table[,c(1,5:148)]
dn1_table[,1]=as.POSIXct(dn1_table[,1], format="\%m/\%d/\%Y \%H:\%M:\%S", tz="GMT")
geom_psd(dn1_table,fsz=10)
}
}
