% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_rma.R
\name{forest_rma}
\alias{forest_rma}
\title{Generate a forest plot from a meta-analysis}
\usage{
forest_rma(model, panels = NULL, study_labels = NULL,
  additional_data = NULL, point_size = NULL, model_label = NULL,
  show_individual_studies = TRUE, show_stats = list(`I^2` =
  ~sprintf("\%0.1f\%\%", I2), p = ~format.pval(QEp, digits = 4, eps = 1e-04,
  scientific = 1)), trans = I, funcs = NULL, format_options = list(colour
  = "black", shape = 15, text_size = 5, banded = TRUE),
  theme = theme_forest(), limits = NULL, breaks = NULL,
  return_data = FALSE, recalculate_width = TRUE,
  recalculate_height = TRUE)
}
\arguments{
\item{model}{a single \code{\link[metafor]{rma}} object or a \code{list} of them}

\item{panels}{\code{list} with details of the panels that make up the plot (See Details)}

\item{study_labels}{a character vector of study labels or list of character vectors the same length as \code{model}}

\item{additional_data}{a \code{data.frame} of additional data that can be referenced for the data
shown in the panels of the forest plot}

\item{point_size}{a numeric vector with the point sizes for the individual studies, or a single value used for
all studies, or a list of numeric vectors if more than one model is to be plotted}

\item{model_label}{a single model label or character vector of model labels the same length as \code{model}}

\item{show_individual_studies}{whether to show the individual studies (the default) or just the summary diamond}

\item{show_stats}{a \code{list} of stats to show at the bottom of the forest plot for e.g. heterogeneity}

\item{trans}{an optional transform function used on the numeric data for plotting the axes}

\item{funcs}{optional list of functions required for formatting \code{panels$display}}

\item{format_options}{formatting options as a list including \code{colour} of the point estimate and
error bars, \code{shape} of the point estimate, \code{banded} whether to show light
grey bands behind alternate rows, \code{text_size} size of text in mm}

\item{theme}{theme to apply to the plot}

\item{limits}{limits of the forest plot on the X-axis (taken as the range of the data
by default)}

\item{breaks}{breaks to appear on the X-axis (note these will be exponentiated
if \code{exponentiate == TRUE})}

\item{return_data}{return the data to produce the plot as well as the plot itself}

\item{recalculate_width}{\code{TRUE} to recalculate panel widths using the current device
or the desired plot width in inches}

\item{recalculate_height}{\code{TRUE} to shrink text size using the current device
or the desired plot height in inches}
}
\value{
plot
}
\description{
Generate a forest plot from a meta-analysis
}
\details{
This produces a forest plot using the \code{\link[metafor]{rma}}
}
\examples{
if (require("metafor")) {
  data("dat.bcg")
  dat <- escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)
  model <- rma(yi, vi, data = dat)

  print(forest_rma(model, study_labels = paste(dat.bcg$author, dat.bcg$year),
    trans = exp))

  print(forest_rma(model, panels = forest_panels(Study = ~study,
    N = ~n, ~vline, `Log Relative Risk` = ~forest(line_x = 0),
    ~spacer(space = 0.10),
    ~sprintf("\%0.3f (\%0.3f, \%0.3f)", estimate, conf.low, conf.high)),
    study_labels = paste(dat.bcg$author, dat.bcg$year),
    trans = exp))

}
}
