% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{matrix_form}
\alias{matrix_form}
\alias{matrix_form,MatrixPrintForm-method}
\title{Transform \code{rtable} to a list of matrices which can be used for outputting}
\usage{
matrix_form(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  indent_size = 2,
  fontspec = NULL,
  col_gap = NULL
)

\S4method{matrix_form}{MatrixPrintForm}(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  indent_size = 2,
  fontspec = NULL,
  col_gap = NULL
)
}
\arguments{
\item{obj}{(\code{ANY})\cr object to be transformed into a ready-to-render form (a \code{\link{MatrixPrintForm}} object).}

\item{indent_rownames}{(\code{flag})\cr if \code{TRUE}, the row names column in the \code{strings} matrix of \code{obj}
will have indented row names (strings pre-fixed).}

\item{expand_newlines}{(\code{flag})\cr whether the generated matrix form should expand rows whose values
contain newlines into multiple 'physical' rows (as they will appear when rendered into ASCII). Defaults
to \code{TRUE}.}

\item{indent_size}{(\code{numeric(1)})\cr number of spaces to be used per level of indent (if supported by
the relevant method). Defaults to 2.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{col_gap}{(\code{numeric(1)})\cr the gap to be assumed between columns, in number of spaces with
font specified by \code{fontspec}.}
}
\value{
A \code{\link{MatrixPrintForm}} classed list with an additional \code{nrow_header} attribute indicating the
number of pseudo "rows" the column structure defines, with the following elements:
\describe{
\item{\code{strings}}{The content, as it should be printed, of the top-left material, column headers, row
labels, and cell values of \code{tt}.}
\item{\code{spans}}{The column-span information for each print-string in the strings matrix.}
\item{\code{aligns}}{The text alignment for each print-string in the strings matrix.}
\item{\code{display}}{Whether each print-string in the strings matrix should be printed or not.}
\item{\code{row_info}}{The \code{data.frame} generated by \code{\link[=basic_pagdf]{basic_pagdf()}}.}
}
}
\description{
Although \code{rtable}s are represented as a tree data structure when outputting the table to ASCII or HTML,
it is useful to map the \code{rtable} to an in-between state with the formatted cells in a matrix form.
}
