% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_fetch_app_code}
\alias{FM_fetch_app_code}
\title{Fetches the Code to Reproduce Analysis}
\usage{
FM_fetch_app_code(session, state, mod_ids)
}
\arguments{
\item{session}{Shiny session variable}

\item{state}{module state after yaml read}

\item{mod_ids}{Vector of module IDs and order they are needed (used for code generation).}
}
\value{
list with the following elements:
\itemize{
  \item{isgood:} Boolean indicating the whether code generation was
  successful
  (\code{TRUE})
\item{msgs:} Any messages generated
\item{code:} Code to regenerate the app
}
}
\description{
Takes the current state of the app and builds a script to
reproduce the analysis within the app.
}
\examples{
# We need a Shiny session object to use this function:
sess_res = DW_test_mksession(session=list())
session = sess_res$session
state   = sess_res$state
app_code = FM_fetch_app_code(session = session,
                             state   = state,
                             mod_ids = c("UD", "DW"))
cat(app_code$code)
}
