% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catcont.R
\docType{methods}
\name{is.cat}
\alias{is.cat}
\alias{is.cat,character-method}
\alias{is.cat,factor-method}
\alias{is.cat,logical-method}
\alias{is.cat,ANY-method}
\alias{is.cont}
\alias{is.cont,numeric-method}
\alias{is.cont,integer-method}
\alias{is.cont,complex-method}
\alias{is.cont,Date-method}
\alias{is.cont,POSIXct-method}
\alias{is.cont,factor-method}
\alias{is.cont,ANY-method}
\alias{which.cat}
\alias{which.cont}
\title{Work with variables as categorical or continuous}
\usage{
is.cat(x, ...)

\S4method{is.cat}{character}(x)

\S4method{is.cat}{factor}(x)

\S4method{is.cat}{logical}(x)

\S4method{is.cat}{ANY}(x)

is.cont(x, ...)

\S4method{is.cont}{numeric}(x)

\S4method{is.cont}{integer}(x)

\S4method{is.cont}{complex}(x)

\S4method{is.cont}{Date}(x)

\S4method{is.cont}{POSIXct}(x)

\S4method{is.cont}{factor}(x)

\S4method{is.cont}{ANY}(x)

which.cat(x, ..., names = FALSE)

which.cont(x, ..., names = FALSE)
}
\arguments{
\item{x}{object}

\item{...}{arguments passed to other functions}

\item{names}{logical; whether to return the names of the variables instead of
their index}
}
\value{
\code{is.cat} returns \code{TRUE} if \code{x} is \code{character}, 
\code{factor} or \code{logical}.  It is \code{FALSE} otherwise.

\code{is.cont} returns \code{TRUE} if \code{x} is \code{numeric}, 
\code{integer}, \code{complex}, \code{Date}, \code{POSIXct}

\code{which.cat} and \code{which.cont} report which variables in an object 
are categorical and which are continuous.  By default, interger indices are
return.  If \code{names=TRUE}, the names of the variables are returned 
instead.
}
\description{
These functions are used to identify which/if a variable or variables are 
categorical or continuos.  \code{is.cat} and \code{is.cont} take single 
variable arguments.  \code{which.cat} and \code{which.cont} take a list or 
data.frame or any structures whose elements have a class method.
}
\details{
These functions facilitate working with variables as categorical or continous
rather than logical, integer, numeric, factor, character, ..
}
\examples{
 \dontrun{
  is.cat(letters)          # TRUE
  is.cat(factor(letters))  # TRUE
  is.cat(TRUE)             # TRUE 
  is.cat(FALSE)            # TRUE
  is.cat(1:10)             # FALSE
  is.cat(rnorm(10))        # FALSE  
  is.cat( now() )          # FALSE 
  
  is.cont(letters)         # FALSE
  is.cont(factor(letters)) # FALSE
  is.cont(TRUE)            # FALSE 
  is.cont(FALSE)           # FALSE
  is.cont(1:10)            # TRUE
  is.cont(rnorm(10))      # TRUE  
  
  which.cat(iris)
  which.cat( iris, names=TRUE )
  
  which.cont( iris )
  which.cont( iris, names=TRUE )
 }
}
\seealso{
\code{\link{which}}, \code{\link{is}}
}
