% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findExclusions.R
\name{findExclusions}
\alias{findExclusions}
\title{Find markers excluding an identification}
\usage{
findExclusions(x, id, candidate, removeMut = TRUE)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{id}{A character of length 1; the name of an untyped member of \code{x}.}

\item{candidate}{A singleton pedigree, with genotypes for the same markers as \code{x}.}

\item{removeMut}{A logical. If TRUE (default), all mutations models are stripped.}
}
\value{
A character vector containing the names of incompatible markers.
}
\description{
Find markers for which the genotypes of a candidate individual is incompatible with a pedigree
}
\examples{

# Pedigree with 3 siblings; simulate data for first two
x = nuclearPed(3) |>
  setMarkers(locusAttributes = NorwegianFrequencies[1:5]) |>
  profileSim(ids = 3:4, seed = 1)

# Simulate random person
poi = singleton(1) |>
  setMarkers(locusAttributes = NorwegianFrequencies[1:5]) |>
  profileSim(seed = 1)

# Identify incompatible markers
findExclusions(x, id = 5, candidate = poi)   # D21S11

# Inspect
plotPedList(c(x, poi), marker = "D21S11", frames = FALSE)

}
