% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forest_profile.R
\name{plot_forest_profile}
\alias{plot_forest_profile}
\title{Visualize the 2D profile of a fractal trees forest}
\usage{
plot_forest_profile(
  tree_df,
  d_col = NULL,
  branch_color = "black",
  leaf_color = "black",
  label = NULL,
  label_size = 4,
  simplify = FALSE,
  dTolerance = 0.15
)
}
\arguments{
\item{tree_df}{A data frame resulting from the \code{build_forest_profile} function, containing the geometry and attributes of the trees.}

\item{d_col}{Name of the column that contains the diameters along the branches. Usually 'diameter'. Default is NULL (diameters are not used).}

\item{branch_color}{A character string specifying the color of the tree branches. Default is 'black'.}

\item{leaf_color}{A character string specifying the color of the tree leaves. Default is 'black'.}

\item{label}{A character string or column name specifying the labels for the trees (typically placed along the x-axis). Default is \code{NULL}.}

\item{label_size}{A numeric value specifying the size of the labels on the plot. Default is \code{4}.}

\item{simplify}{A logical value. If \code{TRUE}, simplifies the geometries of the tree branches using a given tolerance. Default is \code{FALSE}.}

\item{dTolerance}{A numeric value specifying the tolerance parameter used when simplifying geometries, applicable if \code{simplify = TRUE}. Default is \code{0.15}.}
}
\value{
A ggplot object representing the forest profile.
}
\description{
This function generates a 2D visualization of the forest profile using data from a fractal trees.
The forest is plotted with tree branches and leaves. The user can customize the appearance using different parameters.
}
