% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emfrail_methods.R
\name{residuals.emfrail}
\alias{residuals.emfrail}
\title{Residuals for frailty models}
\usage{
\method{residuals}{emfrail}(object, type = "group", ...)
}
\arguments{
\item{object}{An \code{emfrail} object}

\item{type}{One of \code{cluster} or \code{individual}}

\item{...}{Other arguments}
}
\value{
A vector corresponding to the Martingale residuals, either for each cluster or for each individual (row of the data).
}
\description{
Residuals for frailty models
}
\details{
For cluster \eqn{i}, individual \eqn{j} and observation row \eqn{k}, we write the cumulative hazard contribution as
\deqn{\Lambda_{ijk} = \exp(\beta^\top \mathbf{x}_{ijk}) \Lambda_{0, ijk}}
where \eqn{\Lambda_{0, ijk}} is the baseline cumulative hazard correspinding to the row \eqn{(i,j,k)}.

When \code{type == "individual"}, the returned residuals are equal to \eqn{z_i \Lambda_{ijk}} where \eqn{z_i} is the estimated frailty in cluster \eqn{i}.
When \code{type == "cluster"}, the returned residuals are equal to \eqn{\sum_{j,k} \Lambda_{ijk}},
}
