% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FNN.FunctionCollection.R
\name{ANFIS.update}
\alias{ANFIS.update}
\title{ANFIS updating function}
\usage{
ANFIS.update(data.train, def, rule.data.num, miu.rule, func.tsk, varinp.mf,
  step.size = 0.01)
}
\arguments{
\item{data.train}{a matrix (\eqn{m \times n}) of normalized data for the training process, where \eqn{m} is the number of instances and
\eqn{n} is the number of variables; the last column is the output variable.}

\item{def}{a predicted value}

\item{rule.data.num}{a matrix containing the rule base in integer form.}

\item{miu.rule}{a matrix with the degrees of rules. See \code{\link{inference}}.}

\item{func.tsk}{a matrix of parameters of the function on the consequent part using the Takagi Sugeno Kang model.}

\item{varinp.mf}{a matrix of parameters of membership functions of the input variables.}

\item{step.size}{a real number between 0 and 1 representing the step size of
the gradient descent.}
}
\description{
The role of this function is to update parameters in the ANFIS method.
This function is called by the main function of the ANFIS method, \code{\link{ANFIS}}.
}

