\name{nielsen}
\alias{nielsen}
\alias{outer}
\alias{automorphism}
\alias{automorphisms}
\alias{permsymb_single_X}
\alias{permsymb_single_f}
\alias{permsymb_vec}
\alias{permsymb}
\alias{autosub_lowlevel}
\alias{autosub}
\title{Outer automorphisms of the free group}
\description{Vectorized functionality to implement outer automorphisms
  of the free group}
\usage{
permsymb_single_X(X,f)
permsymb_single_f(X,f)
permsymb_vec(X,f)
permsymb(X,f)
autosub_lowlevel(M,e,S)
autosub(X,e,S,automorphism_warning=TRUE)
}
\arguments{
  \item{X,S}{Object of class \code{free}}
  \item{f}{Permutation function}
  \item{M}{Single free group element, in two-row matrix form}
  \item{e}{Single element to substitute}
  \item{automorphism_warning}{Boolean, with default \code{TRUE} meaning
    to give a warning if the requested substitution is not an
    automorphism and \code{FALSE} meaning not to give the warning}
}
\details{
In 1924, Nielsen showed that the automorphism group of the free group
with basis \eqn{[x_1,\ldots,x_n]}{[x_1,...,x_n]} is generated by the
following four elementary Nielsen transformations:

\enumerate{
  \item switch \eqn{x_1} and \eqn{x_2}
  \item Cyclically permute \eqn{x_1,x_2,\ldots,x_n}{x_1,x_2,...,x_n}
  to \eqn{x_2,\ldots,x_n,x_1}{x_2,...,x_n,x_1}
  \item Replace \eqn{x_1} with \eqn{x_1^{-1}}{x_1^-1}
  \item Replace \eqn{x_1} with \eqn{x_1x_2}{x_1 x_2}.
}

The functions documented here give vectorized methods to effect such
outer automorphisms, using the \pkg{permutations} package.

Operations 1 and 2 above generate the symmetric group \eqn{S_n} and such
automorphisms are effected by function \code{permsymb()}.  Operation
3 is carried out by by \code{flip()} and operation 4 by \code{subsymb()}.

Functions \code{permsymb_single_X()}, \code{permsymb_single_f()},
\code{permsymb_vec()} and \code{subsymb_lowlevel()} are low-level helper
functions that are not really suited for the end user; use
\code{permsymb()}, \code{(flip)} and \code{subsymb()} instead.

}
\references{
  Wikipedia contributors. (2018, October 29).  \dQuote{Automorphism
group of a free group}. In \emph{Wikipedia, The Free
Encyclopedia}. Retrieved 19:58, January 10, 2019, from
\url{https://en.wikipedia.org/w/index.php?title=Automorphism_group_of_a_free_group&oldid=866270661}
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{flip}}}
\note{

  Function \code{permsymb()} is intended to work nicely with the
  \pkg{permutations} package; see \code{inst/outer.Rmd} for some
  illustrations.  The function is not perfect. }

\examples{

P <- as.free(c("abc","aba","cc","ca"))
autosub(P,"c",as.free("xyz"))

flip(P,"c")
flip(P,"ac")



}
