% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_atlas_region_agg.R
\name{fs.spread.value.over.region}
\alias{fs.spread.value.over.region}
\title{Spread a single value for a region to all region vertices.}
\usage{
fs.spread.value.over.region(annot, region_value_list,
  value_for_unlisted_regions = NaN)
}
\arguments{
\item{annot, }{annotation. The result of calling fs.read.annot.}

\item{region_value_list, }{named list of strings. Each name must be a region name from the annotation, and the value must be the value to spread to all region vertices.}

\item{value_for_unlisted_regions, }{numeric scalar. The value to assign to vertices which are part of atlas regions that are not listed in region_value_list. Defaults to NaN.}
}
\value{
a vector of length n, where n is the number of vertices in the annotation. One could write this to an MGH or curv file for visualization.
}
\description{
Given an annotation and a list of values (one per brain region), return data that has the values for each region mapped to all region vertices.
}
\keyword{internal}
